//
//  NSObject+GetAppleScript.h
//  GetApplescriptResult
//
//  Created by Alykhan Jetha on 09/09/04.
//  Copyright 2004 Marketcircle Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface NSObject (GetAppleScript)

- (NSString *)pathForAppleScriptResource:(NSString *)aName;
- (NSString *)appleScriptSourceResource:(NSString *)aName;

- (NSAppleScript *)appleScriptResource:(NSString *)aName;

- (NSAppleScript *)appleScriptResource:(NSString *)aName 
			   replaceEveryOccurenceOf:(NSString *)first 
								  with:(NSString *)replace;

- (NSAppleScript *)appleScriptResource:(NSString *)aName 
			   replaceEveryOccurenceOf:(NSString *)first 
								  with:(NSString *)replace 
				   andEveryOccurenceOf:(NSString *)second 
								  with:(NSString *)secondReplace;

- (NSAppleScript *)appleScriptResource:(NSString *)aName 
			   replaceEveryOccurenceOf:(NSString *)first 
								  with:(NSString *)replace 
				   andEveryOccurenceOf:(NSString *)second 
								  with:(NSString *)secondReplace
				   andEveryOccurenceOf:(NSString *)third 
								  with:(NSString *)thirdReplace;


- (NSAppleScript *)appleScriptResource:(NSString *)aName 
			   replaceEveryOccurenceOf:(NSString *)first 
								  with:(NSString *)replace 
				   andEveryOccurenceOf:(NSString *)second 
								  with:(NSString *)secondReplace
				   andEveryOccurenceOf:(NSString *)third 
								  with:(NSString *)thirdReplace
				   andEveryOccurenceOf:(NSString *)fourth 
								  with:(NSString *)fourthReplace;

- (void)reportAppleScriptError:(NSDictionary *)error;

- (long)getLongReturnValueForAppleScript:(NSAppleScript *)script;
- (long)getLongReturnValueForAppleScriptResource:(NSString *)aName;
- (long)getLongReturnValueForAppleScriptResource:(NSString *)aName 
						 replaceEveryOccurenceOf:(NSString *)first 
											with:(NSString *)replace; 

- (long)getLongReturnValueForAppleScriptResource:(NSString *)aName 
						 replaceEveryOccurenceOf:(NSString *)first 
											with:(NSString *)replace 
							 andEveryOccurenceOf:(NSString *)second 
											with:(NSString *)secondReplace;

- (NSString *)getStringValueForAppleScript:(NSAppleScript *)script;

- (NSString *)getStringValueForAppleScriptResource:(NSString*)aName
						   replaceEveryOccurenceOf:(NSString *)first 
											  with:(NSString *)replace 
							   andEveryOccurenceOf:(NSString *)second 
											  with:(NSString *)secondReplace;

- (NSString *)getStringValueForAppleScriptResource:(NSString*)aName
						   replaceEveryOccurenceOf:(NSString *)first 
											  with:(NSString *)replace 
							   andEveryOccurenceOf:(NSString *)second 
											  with:(NSString *)secondReplace
							   andEveryOccurenceOf:(NSString *)third 
											  with:(NSString *)thirdReplace;


- (NSString *)getStringValueForAppleScriptResource:(NSString*)aName
						   replaceEveryOccurenceOf:(NSString *)first 
											  with:(NSString *)replace 
							   andEveryOccurenceOf:(NSString *)second 
											  with:(NSString *)secondReplace
							   andEveryOccurenceOf:(NSString *)third 
											  with:(NSString *)thirdReplace
							   andEveryOccurenceOf:(NSString *)fourth 
											  with:(NSString *)fourthReplace;

/*
 Expect an applescript that returns an array of values. Takes those values, looks for the mapping rule at the same index in mappings, applies the mapping and insert the key value pair into the dictionary using takeValueForKeyPath: so you can pass a flat dictionary or a nested plist. The order of the mappings must exactly match the return values! 
 
 The format of each mapping dictionary is:
 	{
		keypath = "myObject.path";
		type = I;
		dateformat = "%Y %m %d";
		conversion = rtf (or rtfd)
	 }
 
 Supported types are;
 	B (boolean)
 	L (long)
 	S (string)
 	X (data)
 	D (date/time)  (requires dateformat)
 	W (string to data) (requires conversion)
 
 If you pass in nil for the mappings, strings are used for the values and the index is the key (as a string)
 
 */
- (void)populateDictionary:(NSMutableDictionary *)dictionary withReturnValueOfAppleScript:(NSAppleScript *)script 
			  mappingRules:(NSArray *)mappings ignoreEmptyStrings:(BOOL)ignore suppressError:(BOOL)suppress;
- (void)populateArray:(NSMutableArray *)array withArrayOfDictionariesFromReturnValueOfAppleScript:(NSAppleScript *)script mappingRules:(NSArray *)mappings ignoreEmptyStrings:(BOOL)ignore suppressError:(BOOL)suppress;
- (void)populateDictionary:(NSMutableDictionary *)dictionary withAppleEventDescriptor:(NSAppleEventDescriptor *)appleEventDescriptor mappingRules:(NSArray *)mappings ignoreEmptyStrings:(BOOL)ignore;


@end
